{$I TADBMRO.INC}

{*********************************************************}
{*		    MROUNIT2.PAS 2.00			 *}
{*     Copyright (c) Tamarack Associates 1995, 1996.	 *}
{*		   All rights reserved. 		 *}
{*********************************************************}

unit MROUnit2;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes, WinProcs,
  {$ENDIF}
  SysUtils, Messages, Classes, Graphics, Controls, Forms, DBCtrls,
  StdCtrls, Grids, Mask, ExtCtrls, DBGrids, DB, DBTables,
  {$IFDEF UseInfoPower}
  Wwtable, Wwdatsrc, Wwdbigrd, Wwdbgrid,
  {$ENDIF}
  taDBMRO;

type
  TForm1 = class(TForm)
    DataSource1: TDataSource;
    Table1: TTable;
    taDBMRO1: TtaDBMRO;
    Panel1: TPanel;
    DBEdit1: TDBEdit;
    DBNavigator1: TDBNavigator;
    Table1Company: TStringField;
    Table1Contact: TStringField;
    Table1State: TStringField;
    DBComboBox1: TDBComboBox;
    procedure taDBMRO1DrawControl(Sender: TObject; Control: TControl;
      const CellRect: TRect);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.taDBMRO1DrawControl(Sender: TObject;
  Control: TControl; const CellRect: TRect);
var  S : string;
     Rect : TRect;
     DrawFont : TFont;
     Offset : INTEGER;
begin
 if Control is TDBComboBox then
  with TDBComboBox(Control) do
   begin
    if not Visible then exit;
    S := '';
    if DataSource <> nil then
     try
      S := DataSource.DataSet.FieldByName(DataField).DisplayText;
     except
      on EDatabaseError do
      else raise
     end;
    Rect     := CalcRect(Control,CellRect);
    {$IFDEF WIN32}
    IF NewStyleControls THEN InflateRect(Rect,-1,-1);
    {$ENDIF}
    DrawFont := taDBMRO1.FetchFont(Font);
    Offset   := taDBMRO1.GetFontOffset(DrawFont);
    taDBMRO1.DrawString(taLeftJustify,taDBMRO1.FetchColor(Color),Enabled,DrawFont,
		      Offset,Offset,Rect,S);
    taDBMRO1.DrawBorder(bsSingle,Ctl3D,TRUE,Rect)
   end
 else taDBMRO1.DrawControl(Control,CellRect)
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 taDBMRO1.FormKeyDown(ActiveControl,Key,Shift)
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Application.OnIdle := taDBMRO1.ApplicationIdle
end;

end.
